unit DataModule;

interface

uses
  Windows, SysUtils, Classes, DB, ADODB, Forms, Dialogs;

const cnMaxLen = 255;


type
  TDM = class(TDataModule)
    ADOConnection1: TADOConnection;
    ADOQuery1: TADOQuery;
    ds: TDataSource;
    procedure DataModuleDestroy(Sender: TObject);
    procedure DataModuleCreate(Sender: TObject);

  private
    function DajNazweKomputera() : String;
  public

  end;

var
  DM: TDM;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
function TDM.DajNazweKomputera() : String;
var
	sCompName     : String;
   dwCompNameLen : DWord;

begin
	dwCompNameLen := cnMaxLen - 1;
   SetLength(sCompName, cnMaxLen);
   GetComputerName(Pchar(sCompName), dwCompNameLen);
   SetLength(sCompName, dwCompNameLen);

   Result := sCompName;

   if dwCompNameLen = cnMaxLen-1 then
   begin
      Result := '';
   end
   else begin
      Result := UpperCase(Result[1]) + LowerCase(Copy(Result,2,Length(Result)-1));
   end;
end;

procedure TDM.DataModuleDestroy(Sender: TObject);
begin
   ADOQuery1.Active         := false;
   ADOConnection1.Connected := false;
end;

procedure TDM.DataModuleCreate(Sender: TObject);
var
	isOK    : Boolean;
   cs      : String;
   nazwak  : String;

begin
   (*
   prba poczenia z lokalnym serwerem SQL Server 2005 Express

   dla lokalnego poczenia z MS SQL Server 2005 Express - z baz danych Biblioteka - CS jest zbudowane nastepujco:                                                        tutaj nazwa komputera + \SQLEXPRESS

   //                                                                                                             tutaj nazwa komputera + \SQLEXPRESS
	Provider=SQLNCLI.1;Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=Biblioteka;Data Source=NAZWA_KOMPUTERA\SQLEXPRESS

	*)
   nazwak := DajNazweKomputera();
   cs := 'Provider=SQLNCLI.1;Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=Biblioteka;Data Source=' + nazwak + '\SQLEXPRESS';

   isOK := false;

	try
      ADOConnection1.Close();

      ADOConnection1.ConnectionString := cs;
 	   ADOConnection1.Connected        := true;
      isOK := true;
	except
		ShowMessage('Bd poczenia z serwerem bazy danych - ZDEFINUJ WASNY ConnectionString!');
      Application.Terminate();
   end;

   // jeeli poczenie zlokalnym serwerem si udao
   if isOK then
   begin
      ADOQuery1.Open();
   	exit;
   end;
end;

end.

